<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Services;

use Modules\Member\Models\MemberAddress;

class AddressService {

	/**
	 * @title 获取会员列表
	 *
	 * @param [type] $request
	 * @return void
	 */
	public function getDataList($request){
		$map = [];

		if ($request->filled('title')) {
			$map[] = ['title', 'like', '%' . $request->input('title') . '%'];
		}
		if ($request->filled('name')) {
			$map[] = ['name', 'like', '%' . $request->input('name') . '%'];
		}
		if($request->filled('is_user')){
			$map[] = ['member_id', '=', auth('api')->user()['uid']];
		}

		$query = MemberAddress::where($map)->orderBy('id', 'desc');

		if($request->filled('page')){
			$data = [
				'total' => $query->count(),
				'page' => $request->input('page', 1),
				'data' => $query->offset($request->input('offset', 0))->limit($request->input('limit', 10))->get(),
			];
		}else{
			$data = $query->get();
		}
		return $data;
	}

	public function getData($request){
		$address = MemberAddress::where('member_id', '=', auth('api')->user()['uid'])->where('id', $request->input('id'))->first();

		if(!$address){
			throw new \Exception("收货地址为空", 1);
		}
		return $address;
	}

	/**
	 * @title 添加用户收货地址
	 *
	 * @param Request $request
	 * @param MemberService $service
	 * @return void
	 */
	public function create($request){
		$request->validate([
			'name' => 'required|max:255',
			'mobile' => 'required'
		]);
		$address = new MemberAddress();
        foreach($address->setFilterFields($request->all()) as $key => $value){
			$address->$key = $value;
		}
		$address->member_id = auth('api')->user()['uid'];
		if($address->is_default){
			MemberAddress::where('member_id', '=', auth('api')->user()['uid'])->update(['is_default' => 0]);
		}
		$address->save();
		return $address;
	}

	/**
	 * @title 修改会员
	 *
	 * @param Request $request
	 * @param MemberService $service
	 * @return void
	 */
	public function update($request){
		$request->validate([
			'name' => 'required|max:255',
			'mobile' => 'required'
		]);

		try {
			$address = MemberAddress::findOrFail($request->input('id'));
		} catch (\Throwable $th) {
			throw new \Exception("地址不存在！", 1);
		}

		foreach($address->setFilterFields($request->all()) as $key => $value){
			$address->$key = $value;
		}

		if($address->is_default){
			MemberAddress::where('member_id', '=', auth('api')->user()['uid'])->update(['is_default' => 0]);
		}
		$address->save();
		return $address;
	}

	public function delete($request){
		if($request->filled('id')){
			try {
				$address = MemberAddress::findOrFail($request->input('id'));
			} catch (\Throwable $th) {
				throw new \Exception("收货地址不存在！", 1);
			}
			$address->delete();
		}
		if($request->filled('ids')){
			try {
				$address = MemberAddress::whereIn('id', $request->input('ids'));

				$address->delete();
			} catch (\Throwable $th) {
				throw new \Exception($th->getMessage(), 1);
			}
		}

		return $address;
	}
}
