<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Models;

use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Support\Facades\Hash;

class Member extends Authenticatable implements JWTSubject {
	use Notifiable;

	protected $table = 'member';
	protected $primaryKey = 'uid';
    protected $fillable = ['username', 'nickname', 'email', 'mobile', 'password', 'status', 'invite_uid'];
    protected $hidden = ['password', 'deleted_at'];
    protected $dateFormat = 'Y-m-d H:i:s';

	/**
	 * Get the identifier that will be stored in the subject claim of the JWT.
	 *
	 * @return mixed
	 */
	public function getJWTIdentifier() {
		return $this->getKey();
	}

	/**
	 * Return a key value array, containing any custom claims to be added to the JWT.
	 *
	 * @return array
	 */
	public function getJWTCustomClaims() {
		return [];
	}

	protected function casts(): array {
		return [
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
			'deleted_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	public function password() : Attribute {
		return new Attribute(
			set: fn ($value) => Hash::make($value),
		);
	}

	public function social(){
		return $this->hasMany(\Modules\Wechat\Models\MemberSocial::class, 'member_id', 'uid');
	}

	public function level(){
		return $this->belongsTo(MemberLevel::class, 'level_id', 'id');
	}

	public function address(){
		return $this->hasMany(MemberAddress::class, 'member_id', 'id');
	}
}
