<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Listeners;

use Modules\Member\Events\MemberDelete;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Modules\Member\Models\MemberAccount;
use Modules\Member\Models\MemberScore;
use Modules\Member\Models\MemberLevel;

class DeleteMember implements ShouldQueue {

	/**
	 * @title 会员登录后更新用户信息
	 *
	 * @param LoginEvent $event
	 * @return void
	 */
	public function handle(MemberDelete $event) {
		$uid = $event->uid;

		MemberAccount::where('member_id', $uid)->delete();
		MemberScore::where('member_id', $uid)->delete();
		MemberLevel::where('member_id', $uid)->delete();

		return true;
	}
}
