<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Goods\Models;

use App\Models\BaseModel;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Modules\Goods\Observers\GoodsObserver;
use Illuminate\Database\Eloquent\Attributes\ObservedBy;

#[ObservedBy([GoodsObserver::class])]
class Goods extends BaseModel {

	protected $table = 'goods';
	protected $fillable = [
		'title', 'user_id', 'brand_id', 'description', 'tags', 'goods_type','cover', 'images', 'price', 'original_price',
		'service_amount', 'master_amount', 'partner_amount', 'is_partner', 'operate', 'content', 'status','goods_sn'
	];
	// protected $hidden = ['deleted_at'];

	protected function casts(): array {
		return [
			'operate'  => 'json',
			'tags'     => 'json',
			'images'   => 'json',
			'spec_list' => 'json',
			'status' => 'integer',
			'created_at' => 'datetime:Y-m-d H:i:s',
			'updated_at' => 'datetime:Y-m-d H:i:s',
		];
	}

	/**
	 * @title 商品关联店铺
	 *
	 * @return void
	 */
	public function store(){
		return $this->belongsTo(\Modules\Store\Models\Store::class, 'store_id', 'id');
	}

	public function category(){
		return $this->belongsToMany(Category::class, 'goods_has_category', 'goods_id', 'category_id');
	}

	public function sku(){
		return $this->hasMany(GoodsSku::class, 'goods_id', 'id');
	}
}
