<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Models;

class Role extends \App\Models\BaseModel {

	protected $table = 'auth_roles';
	protected $fillable = ['title', 'name', 'data_range', 'sort', 'status', 'description'];
	protected $hidden = ['deleted_at'];

	public function admins(){
		return $this->belongsToMany(Admin::class, 'auth_admins_roles', 'role_id', 'uid');
	}
	public function permissions(){
		return $this->belongsToMany(Permission::class, 'auth_roles_permissions', 'role_id', 'permission_id');
	}
}
