<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Request;
use App\Http\Middleware\AuthCheckMiddleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
		api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        then: function(){
			Route::middleware(['api'])
				->prefix('admin')
				->name('admin.')
				->group(base_path('routes/admin.php'));
        },
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
		$middleware->alias([
			'auth.check' => AuthCheckMiddleware::class
		]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        $exceptions->shouldRenderJsonWhen(function(Request $request, Throwable $e){
			// if($request->is('admin/*')){
			// 	return true;
			// }
			return $request->expectsJson();
		});
    })->create();
